import json
import requests
import pandas as pd 
import awswrangler as wr

def lambda_handler(event, context):
   
    generos = event['generos']
    cantidad_total_por_genero = 500
    
    for genero in generos:
        libros_del_genero = buscar_libros_por_genero(genero, cantidad_total_por_genero)
        escribir_datos_s3(libros_del_genero, genero)
    
    return True

def buscar_libros_por_genero(genero, cantidad=100):
    url = f'http://openlibrary.org/search.json?q={genero}&limit={cantidad}'
    response = requests.get(url)
    data = response.json()
    libros = data['docs']
    return libros

def escribir_datos_s3(data: list, genero : str):
    genero = genero.replace(" ", "_")
    libros_df = pd.DataFrame(data)
    #libros_df = libros_df.iloc[:, :51]
    libros_df['genre'] = genero
    prefix_s3 = f"s3://cad-raw-data/libros/{genero}"
    
    #wr.s3.to_csv(df=libros_df, 
    #            path=f'{prefix_s3}/libros.csv',
    #            #dataset = True,
    #            header =True,
    #            #database = 'cad-raw-data',
    #            #table = f"libros_{genero}",
    #            #mode = 'overwrite',
    #            index=False)
    #            
    wr.s3.to_csv(df=libros_df, 
                path=f'{prefix_s3}/',
                dataset = True,
                database = 'cad-raw-data',
                table = f"libros_{genero}",
                mode = 'overwrite',
                index=False)




